/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.writers;

import eu.europa.ec.taxud.cesop.domain.MessageTypeEnum;
import eu.europa.ec.taxud.cesop.domain.ValidationError;
import eu.europa.ec.taxud.cesop.domain.ValidationErrorTypeEnum;
import eu.europa.ec.taxud.cesop.domain.ValidationResultTypeEnum;
import eu.europa.ec.taxud.cesop.domain.XmlPaymentDataMsg;
import eu.europa.ec.taxud.cesop.domain.XmlTypeAndValue;
import eu.europa.ec.taxud.cesop.utils.LangUtils;
import eu.europa.ec.taxud.cesop.utils.ValidationConstants;
import eu.europa.ec.taxud.cesop.utils.ValidationErrorUtils;
import eu.europa.ec.taxud.cesop.writers.CesopXmlWriter;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;

public class ValidationMessageXmlWriter
extends CesopXmlWriter<OutputStream> {
    public ValidationMessageXmlWriter(OutputStream outputStream) throws XMLStreamException {
        super(outputStream);
    }

    public void createValidationMessage(XmlPaymentDataMsg paymentDataMsg, List<ValidationError> validationErrors) throws XMLStreamException {
        this.writeStartValidationMessage(paymentDataMsg);
        if (paymentDataMsg != null) {
            this.writeMessageSpec(paymentDataMsg, MessageTypeEnum.VLD);
            this.writeEOL();
        }
        this.writeValidationResult(validationErrors, paymentDataMsg == null ? "4.03" : paymentDataMsg.getCesopVersion());
        this.writeEndValidationMessage();
    }

    public void createPingValidationMessage(XmlPaymentDataMsg paymentDataMsg) throws XMLStreamException {
        this.writeStartValidationMessage(paymentDataMsg);
        if (paymentDataMsg != null) {
            this.writeMessageSpec(paymentDataMsg, MessageTypeEnum.PNG);
        }
        this.writeEndValidationMessage();
    }

    private void writeEndValidationMessage() throws XMLStreamException {
        this.writeEOL();
        this.writeEndElement();
        this.writeEOL();
        this.flush();
    }

    private void writeStartValidationMessage(XmlPaymentDataMsg paymentDataMsg) throws XMLStreamException {
        this.writeStartDocument();
        this.writeEOL();
        this.writeStartElement(ValidationConstants.XML.CESOP_QNAME);
        this.writeAttribute("version", this.getVersionAttribute(paymentDataMsg));
        this.writeNamespace();
        this.writeEOL();
    }

    private String getVersionAttribute(XmlPaymentDataMsg paymentDataMsg) {
        return paymentDataMsg == null || paymentDataMsg.getCesopVersion() == null ? "" : paymentDataMsg.getCesopVersion();
    }

    private void writeMessageSpec(XmlPaymentDataMsg paymentDataMsg, MessageTypeEnum messageType) throws XMLStreamException {
        this.writeStartElement(ValidationConstants.XML.MESSAGE_SPEC_QNAME);
        this.writeEOL();
        this.writeTag(ValidationConstants.XML.TRANSMITTING_COUNTRY_QNAME, paymentDataMsg.getCountry());
        this.writeTag(ValidationConstants.XML.MESSAGE_TYPE_QNAME, messageType.getLabel());
        this.writeTag(ValidationConstants.XML.MESSAGE_TYPE_INDIC_QNAME, paymentDataMsg.getMessageType());
        this.writeTag(ValidationConstants.XML.MESSAGE_REF_ID_QNAME, Optional.ofNullable(paymentDataMsg.getVldMessageRefId()).orElse(UUID.randomUUID().toString()).toUpperCase());
        this.writeTag(ValidationConstants.XML.CORR_MESSAGE_REF_ID_QNAME, paymentDataMsg.getMessageRefId());
        if (paymentDataMsg.getSendingPspIdentifier() != null) {
            this.writeStartElement(ValidationConstants.XML.SENDING_PSP_QNAME);
            this.writeEOL();
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("PSPIdType", paymentDataMsg.getSendingPspIdentifierType());
            if (paymentDataMsg.getSendingPspIdentifierOther() != null) {
                attributes.put("PSPIdOther", paymentDataMsg.getSendingPspIdentifierOther());
            }
            this.writeTagWithAttributes(ValidationConstants.XML.PSP_ID_QNAME, paymentDataMsg.getSendingPspIdentifier(), attributes);
            for (XmlTypeAndValue pspName : paymentDataMsg.getSendingPspNames()) {
                attributes = new HashMap();
                attributes.put("nameType", pspName.getType());
                if (pspName.getOther() != null) {
                    attributes.put("nameOther", pspName.getOther());
                }
                this.writeTagWithAttributes(ValidationConstants.XML.NAME_QNAME, pspName.getValue(), attributes);
            }
            this.writeEndElement();
            this.writeEOL();
        }
        this.writeStartElement(ValidationConstants.XML.REPORTING_PERIOD_QNAME);
        this.writeEOL();
        this.writeTag(ValidationConstants.XML.QUARTER_QNAME, (Integer)(paymentDataMsg.getReportingPeriod() % 10));
        this.writeTag(ValidationConstants.XML.YEAR_QNAME, (Integer)(paymentDataMsg.getReportingPeriod() / 10));
        this.writeEndElement();
        this.writeEOL();
        this.writeTag(ValidationConstants.XML.TIMESTAMP_QNAME, ValidationErrorUtils.XML_DATE_TIME_FORMATTER.format(Optional.ofNullable(paymentDataMsg.getProcessedOn()).map(v -> v.atOffset(ZoneOffset.UTC)).orElse(OffsetDateTime.now())));
        this.writeEndElement();
    }

    private void writeValidationResult(List<ValidationError> validationErrors, String xsdVersion) throws XMLStreamException {
        this.writeStartElement(ValidationConstants.XML.VALIDATION_RESULT_QNAME);
        this.writeEOL();
        ValidationResultTypeEnum validationResultTypeEnum = validationErrors.stream().anyMatch(ValidationError::isFullRejection) ? ValidationResultTypeEnum.FULLY_REJECTED : (validationErrors.isEmpty() ? ValidationResultTypeEnum.VALIDATED : ValidationResultTypeEnum.PARTIALLY_REJECTED);
        this.writeTag(ValidationConstants.XML.VALIDATION_RESULT_QNAME, validationResultTypeEnum.getCode());
        for (ValidationError validationError : validationErrors) {
            String errorCode = ValidationErrorTypeEnum.isSupported(validationError.getErrorType(), xsdVersion) ? validationError.getErrorCode() : ValidationErrorTypeEnum.CM_TR_9999.getCode();
            this.writeStartElement(ValidationConstants.XML.VALIDATION_ERRORS_QNAME);
            this.writeEOL();
            this.writeTag(ValidationConstants.XML.ERROR_CODE_QNAME, errorCode);
            this.writeTag(ValidationConstants.XML.ERROR_COUNTER_QNAME, validationError.getErrorCounter());
            this.writeTag(ValidationConstants.XML.ERROR_SHORT_DESC_QNAME, validationError.getErrorShortDesc());
            this.writeTag(ValidationConstants.XML.ERROR_DESCRIPTION_QNAME, validationError.getErrorLongDesc());
            if (LangUtils.isNotBlank(validationError.getTransactionIdentifier())) {
                this.writeTag(ValidationConstants.XML.TRANSACTION_IDENTIFIER_QNAME, validationError.getTransactionIdentifier());
            }
            if (LangUtils.isNotBlank(validationError.getDocRefId())) {
                this.writeTag(ValidationConstants.XML.DOC_REF_ID_QNAME, validationError.getDocRefId());
            }
            this.writeEndElement();
            this.writeEOL();
        }
        this.writeEndElement();
    }
}

